#ifndef _MPUSBAPI_H_
#define _MPUSBAPI_H_

#define	MPUSB_FAIL                  0
#define MPUSB_SUCCESS               1

#define MP_WRITE                    0
#define MP_READ                     1

// MAX_NUM_MPUSB_DEV is an abstract limitation.
// It is very unlikely that a computer system will have more
// then 127 USB devices attached to it. (single or multiple USB hosts)
#define MAX_NUM_MPUSB_DEV           127

extern "C" __declspec(dllexport) DWORD MPUSBGetDLLVersion(void);

extern "C" __declspec(dllexport) DWORD MPUSBGetDeviceCount(PCHAR pVID_PID);

// Input, Input, Input, Input, Input <Future Use>
extern "C" __declspec(dllexport) HANDLE MPUSBOpen(DWORD instance,PCHAR pVID_PID,PCHAR pEP,DWORD dwDir,DWORD dwReserved);

// Input, Output, Input, Output, Input
extern "C" __declspec(dllexport) DWORD MPUSBRead(HANDLE handle,PVOID pData,DWORD dwLen,PDWORD pLength,DWORD dwMilliseconds);

// Input, Input, Input, Output, Input
extern "C" __declspec(dllexport) DWORD MPUSBWrite(HANDLE handle,PVOID pData,DWORD dwLen,PDWORD pLength,DWORD dwMilliseconds);

// Input, Output, Input, Output, Input
extern "C" __declspec(dllexport) DWORD MPUSBReadInt(HANDLE handle,PVOID pData,DWORD dwLen,PDWORD pLength,DWORD dwMilliseconds);

extern "C" __declspec(dllexport) BOOL MPUSBClose(HANDLE handle);

// Input, Output, Input, Output
extern "C" __declspec(dllexport) DWORD MPUSBGetDeviceDescriptor(HANDLE handle,PVOID pDevDsc,DWORD dwLen,PDWORD pLength);

extern "C" __declspec(dllexport) DWORD MPUSBGetConfigInfoSize(HANDLE handle);

// Input, Output, Input
extern "C" __declspec(dllexport) DWORD MPUSBGetConfigInfo(HANDLE handle,PVOID pData,DWORD dwLen);

// Input, Input, Output, Input, Output
extern "C" __declspec(dllexport) DWORD USB4ALLStringDescriptor(HANDLE handle, UCHAR ucInd, PVOID pDevDsc, DWORD dwLen, PDWORD pLength);

#endif
